clear all

* Set output folder

cd ..\Outputs

* Call join database

use SEMESTER, clear

* Winsorize extreme observations

* Actual Output

gen dlogY=log(GD1/l.GD1)*200
winsor dlogY, p(0.02) gen(dlogYw)

* Smoothed Actual

gen dlogYs=hpGYIMF10
winsor dlogYs, p(0.02) gen(dlogYws)
			
* Potential output

replace GPIMFtp0gtm0=GPIMFtp0gtm0*100
winsor GPIMFtp0gtm0, p(0.02) gen(GPIMFtp0gtm0w)

* Generate differences

capture drop D_actual_minus_potential
gen D_actual_minus_potential=dlogYw-GPIMFtp0gtm0w
capture drop D_actual_minus_potential2
gen D_actual_minus_potential2=dlogYws-GPIMFtp0gtm0w

* Norway has a problem with potential output. It is dropped
foreach var in PROD1 PROD3 MONSH5 FE0 FE1 sGGSB OILS1 OILS2 OILS3 OILS4 OILS5 OILS6 OILS7 OILS8 {
	replace `var'=. if ISO=="NOR"
}

quiet forvalues i=1(1)78 {
	gen _tt_`i'=(tt==`i')
}

compress
gen t=_n		 
local confidenceval=0.95
if `confidenceval'==1.65 local confidencestr="90%"
if `confidenceval'==0.95 local confidencestr="66%"
			
*===============================================================================
*			           IRFS to different shocks
*===============================================================================

foreach var in PROD3 OILS2 OILS8 MONSH5 FE1 {
	
	if "`var'"=="PROD3" local var_str="Labor productivity shock"
	if "`var'"=="MONSH5" local var_str="Monetary policy shock (VAR)"
	if "`var'"=="FE1" local var_str="Gov't spending shock (AG 2013)"
	if "`var'"=="OILS2" local var_str="Oil price shock (Kilian 2009)"
	if "`var'"=="OILS8" local var_str="Oil price shock (Baumeister and Hamilton 2015)"
	
	capture drop Z*
	gen Z=`var'
	winsor Z, p(0.02) gen(Zw)	
	replace Z=Zw
	
	* convert shocks to one standard deviation
	
	sum Z
	replace Z=Z/r(sd)

	gen Z0=Z
	gen Z1=l.Z
	gen Z2=l2.Z
	gen Z3=l3.Z
	gen Z4=l4.Z

	drop Z
	
	capture drop irf*
	*** time for IRFs
	gen irf_0=t-1
	
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*    				             Actual output
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	xtscc dlogYw Z0 Z1 Z2 Z3 Z4 _tt* if GPIMFtp0gtm0~=., fe
		
	gen irf_act_m=.
	gen irf_act_se=.	
	local str0="Z0"
	lincom "`str0'"
	replace irf_act_m=r(estimate) if irf_0==0
	replace irf_act_se=r(se) if irf_0==0
		
	forvalues i=1(1)4 {
		local str0="`str0'" + "+Z`i'" 
		lincom "`str0'"
		replace irf_act_m=r(estimate) if irf_0==`i'
		replace irf_act_se=r(se) if irf_0==`i'
	}		
		
	gen irf_act_m_up=irf_act_m+`confidenceval'*irf_act_se
	gen irf_act_m_lo=irf_act_m-`confidenceval'*irf_act_se		

	*** test cumulative sum for the actual is zero	
	lincom Z0+Z1+Z2+Z3+Z4
	local pval_act_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f")
	*** test pointwise that the actual output IRF (growth rate) is zero for the growth rate
	test Z0 Z1 Z2 Z3 Z4
	local pval_act_irf_point=strofreal(r(p),"%4.3f") 
	
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*    						Smoothed actual output
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	xtscc dlogYws Z0 Z1 Z2 Z3 Z4 _tt* if GPIMFtp0gtm0~=., fe
		
	gen irf_sact_m=.
	gen irf_sact_se=.	
	local str0="Z0"
	lincom "`str0'"
	replace irf_sact_m=r(estimate) if irf_0==0
	replace irf_sact_se=r(se) if irf_0==0
		
	forvalues i=1(1)4 {
		local str0="`str0'" + "+Z`i'" 
		lincom "`str0'"
		replace irf_sact_m=r(estimate) if irf_0==`i'
		replace irf_sact_se=r(se) if irf_0==`i'
	}		
		
	gen irf_sact_m_up=irf_sact_m+`confidenceval'*irf_sact_se
	gen irf_sact_m_lo=irf_sact_m-`confidenceval'*irf_sact_se		

	*** test cumulative sum for the actual is zero	
	lincom Z0+Z1+Z2+Z3+Z4
	local pval_sact_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f")
	*** test pointwise that the actual output IRF (growth rate) is zero for the growth rate
	test Z0 Z1 Z2 Z3 Z4
	local pval_sact_irf_point=strofreal(r(p),"%4.3f") 
	
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*               			  Potential output
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	xtscc GPIMFtp0gtm0w Z0 Z1 Z2 Z3 Z4 _tt* if GPIMFtp0gtm0~=., fe
		
	gen irf_pot_m=.
	gen irf_pot_se=.
	local str0="Z0"
	lincom "`str0'"
	replace irf_pot_m=r(estimate) if irf_0==0
	replace irf_pot_se=r(se) if irf_0==0
		
	forvalues i=1(1)4 {
		local str0="`str0'" + "+Z`i'" 
		lincom "`str0'"
		replace irf_pot_m=r(estimate) if irf_0==`i'
		replace irf_pot_se=r(se) if irf_0==`i'
	}	
	
	gen irf_pot_m_up=irf_pot_m+`confidenceval'*irf_pot_se
	gen irf_pot_m_lo=irf_pot_m-`confidenceval'*irf_pot_se
	
	*** test cumulative sum for the potential is zero
	lincom Z0+Z1+Z2+Z3+Z4
	local pval_pot_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f") 
	
	*** test pointwise that the potential output IRF (growth rate) is zero for the growth rate
	test Z0 Z1 Z2 Z3 Z4
	local pval_pot_irf_point=strofreal(r(p),"%4.3f") 

	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				       IRF for actual output - potential
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	xtscc D_actual_minus_potential Z0 Z1 Z2 Z3 Z4 _tt* if GPIMFtp0gtm0~=., fe

	*** test cumulative sum for the actual is zero	
	lincom Z0+Z1+Z2+Z3+Z4 
	local pval_dif_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f")

	*** test pointwise that the actual output IRF (growth rate) is zero for the growth rate
	test Z0 Z1 Z2 Z3 Z4
	local pval_dif_irf_point=strofreal(r(p),"%4.3f") 
	
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				IRF for smoothed actual output - potential
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	xtscc D_actual_minus_potential2 Z0 Z1 Z2 Z3 Z4 _tt* if GPIMFtp0gtm0~=., fe

	*** test cumulative sum for the actual is zero	
	lincom Z0+Z1+Z2+Z3+Z4 
	local pval_sdif_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f")

	*** test pointwise that the actual output IRF (growth rate) is zero for the growth rate
	test Z0 Z1 Z2 Z3 Z4
	local pval_sdif_irf_point=strofreal(r(p),"%4.3f") 

	twoway ///
	(rarea irf_act_m_lo irf_act_m_up irf_0 if irf_0<=4, color(gs14)) ///
	(line irf_act_m  irf_0 if irf_0<=4, lcolor(black) lpattern(solid) lwidth(thick)) ///
	(line irf_pot_m  irf_0 if irf_0<=4, lcolor(blue) lpattern(solid)) ///
	(line irf_pot_m_up  irf_0 if irf_0<=4, lcolor(blue) lpattern(longdash)) ///
	(line irf_pot_m_lo  irf_0 if irf_0<=4, lcolor(blue) lpattern(longdash)) ///
	(scatter irf_sact_m  irf_0 if irf_0<=4, connect(direct) lcolor(red)  mcolor(red) mfcolor(white) lpattern(solid)) ///
	(line irf_sact_m_up  irf_0 if irf_0<=4, lcolor(red) lpattern(shortdash)) ///
	(line irf_sact_m_lo  irf_0 if irf_0<=4, lcolor(red) lpattern(shortdash)) ///		
	, ///
	xtitle("") xlabel(0(1)4) ///
	ytitle("") ///
	title("`var_str'") ///
	legend(order(2 1 3 4 6 7 9) ///
	label(1 "`confidencestr' CI") ///
	label(2 "Actual Output       , (`pval_act_irf') [`pval_act_irf_point']") ///
	label(3 "Potential Output   , (`pval_pot_irf') [`pval_pot_irf_point']") ///
	label(4 "`confidencestr' CI") ///
	label(6 "HP Actual ({&lambda}=800), (`pval_sact_irf') [`pval_sact_irf_point']") ///
	label(7 "`confidencestr' CI") ///
	label(9 "HP Actual=Potenti., (`pval_sdif_irf') [`pval_sdif_irf_point']") ///
	rows(4) ring(3) position(7)) ///
	graphregion(color(white)) bgcolor(white) ///		
	name(`var', replace)

}

* Close previous graphs and combine them into a single graph

window manage close graph _all
graph combine PROD3 MONSH5, rows(1) ysize(2) graphregion(color(white)) plotregion(color(white)) name(panela, replace)
graph combine FE1 OILS2, rows(1) ysize(2) graphregion(color(white)) plotregion(color(white)) name(panelb, replace)

window manage close graph _all
graph combine panela panelb, rows(2) altshrink iscale(1.3) graphregion(color(white)) plotregion(color(white))
